<?php
/**
 * States
 *
 * Returns an array of country states. This deprecates and replaces the /states/ directory found in older versions.
 * States /should/ be defined in English and translated native though localisation files.
 * Countries defined with empty arrays have no states.
 *
 * @package WooCommerce/i18n
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

return array(
	'AF' => array(),
	'AO' => array( // Angola states.
		'BGO' => __( 'Bengo' ),
		'BLU' => __( 'Benguela' ),
		'BIE' => __( 'Bié' ),
		'CAB' => __( 'Cabinda' ),
		'CNN' => __( 'Cunene' ),
		'HUA' => __( 'Huambo' ),
		'HUI' => __( 'Huíla' ),
		'CCU' => __( 'Kuando Kubango' ),
		'CNO' => __( 'Kwanza-Norte' ),
		'CUS' => __( 'Kwanza-Sul' ),
		'LUA' => __( 'Luanda' ),
		'LNO' => __( 'Lunda-Norte' ),
		'LSU' => __( 'Lunda-Sul' ),
		'MAL' => __( 'Malanje' ),
		'MOX' => __( 'Moxico' ),
		'NAM' => __( 'Namibe' ),
		'UIG' => __( 'Uíge' ),
		'ZAI' => __( 'Zaire' ),
	),
	'AR' => array( // Argentinian provinces.
		'C' => __( 'Ciudad Aut&oacute;noma de Buenos Aires' ),
		'B' => __( 'Buenos Aires' ),
		'K' => __( 'Catamarca' ),
		'H' => __( 'Chaco' ),
		'U' => __( 'Chubut' ),
		'X' => __( 'C&oacute;rdoba' ),
		'W' => __( 'Corrientes' ),
		'E' => __( 'Entre R&iacute;os' ),
		'P' => __( 'Formosa' ),
		'Y' => __( 'Jujuy' ),
		'L' => __( 'La Pampa' ),
		'F' => __( 'La Rioja' ),
		'M' => __( 'Mendoza' ),
		'N' => __( 'Misiones' ),
		'Q' => __( 'Neuqu&eacute;n' ),
		'R' => __( 'R&iacute;o Negro' ),
		'A' => __( 'Salta' ),
		'J' => __( 'San Juan' ),
		'D' => __( 'San Luis' ),
		'Z' => __( 'Santa Cruz' ),
		'S' => __( 'Santa Fe' ),
		'G' => __( 'Santiago del Estero' ),
		'V' => __( 'Tierra del Fuego' ),
		'T' => __( 'Tucum&aacute;n' ),
	),
	'AT' => array(),
	'AU' => array( // Australian states.
		'ACT' => __( 'Australian Capital Territory' ),
		'NSW' => __( 'New South Wales' ),
		'NT'  => __( 'Northern Territory' ),
		'QLD' => __( 'Queensland' ),
		'SA'  => __( 'South Australia' ),
		'TAS' => __( 'Tasmania' ),
		'VIC' => __( 'Victoria' ),
		'WA'  => __( 'Western Australia' ),
	),
	'AX' => array(),
	'BD' => array( // Bangladeshi states (districts).
		'BD-05' => __( 'Bagerhat' ),
		'BD-01' => __( 'Bandarban' ),
		'BD-02' => __( 'Barguna' ),
		'BD-06' => __( 'Barishal' ),
		'BD-07' => __( 'Bhola' ),
		'BD-03' => __( 'Bogura' ),
		'BD-04' => __( 'Brahmanbaria' ),
		'BD-09' => __( 'Chandpur' ),
		'BD-10' => __( 'Chattogram' ),
		'BD-12' => __( 'Chuadanga' ),
		'BD-11' => __( "Cox's Bazar" ),
		'BD-08' => __( 'Cumilla' ),
		'BD-13' => __( 'Dhaka' ),
		'BD-14' => __( 'Dinajpur' ),
		'BD-15' => __( 'Faridpur ' ),
		'BD-16' => __( 'Feni' ),
		'BD-19' => __( 'Gaibandha' ),
		'BD-18' => __( 'Gazipur' ),
		'BD-17' => __( 'Gopalganj' ),
		'BD-20' => __( 'Habiganj' ),
		'BD-21' => __( 'Jamalpur' ),
		'BD-22' => __( 'Jashore' ),
		'BD-25' => __( 'Jhalokati' ),
		'BD-23' => __( 'Jhenaidah' ),
		'BD-24' => __( 'Joypurhat' ),
		'BD-29' => __( 'Khagrachhari' ),
		'BD-27' => __( 'Khulna' ),
		'BD-26' => __( 'Kishoreganj' ),
		'BD-28' => __( 'Kurigram' ),
		'BD-30' => __( 'Kushtia' ),
		'BD-31' => __( 'Lakshmipur' ),
		'BD-32' => __( 'Lalmonirhat' ),
		'BD-36' => __( 'Madaripur' ),
		'BD-37' => __( 'Magura' ),
		'BD-33' => __( 'Manikganj ' ),
		'BD-39' => __( 'Meherpur' ),
		'BD-38' => __( 'Moulvibazar' ),
		'BD-35' => __( 'Munshiganj' ),
		'BD-34' => __( 'Mymensingh' ),
		'BD-48' => __( 'Naogaon' ),
		'BD-43' => __( 'Narail' ),
		'BD-40' => __( 'Narayanganj' ),
		'BD-42' => __( 'Narsingdi' ),
		'BD-44' => __( 'Natore' ),
		'BD-45' => __( 'Nawabganj' ),
		'BD-41' => __( 'Netrakona' ),
		'BD-46' => __( 'Nilphamari' ),
		'BD-47' => __( 'Noakhali' ),
		'BD-49' => __( 'Pabna' ),
		'BD-52' => __( 'Panchagarh' ),
		'BD-51' => __( 'Patuakhali' ),
		'BD-50' => __( 'Pirojpur' ),
		'BD-53' => __( 'Rajbari' ),
		'BD-54' => __( 'Rajshahi' ),
		'BD-56' => __( 'Rangamati' ),
		'BD-55' => __( 'Rangpur' ),
		'BD-58' => __( 'Satkhira' ),
		'BD-62' => __( 'Shariatpur' ),
		'BD-57' => __( 'Sherpur' ),
		'BD-59' => __( 'Sirajganj' ),
		'BD-61' => __( 'Sunamganj' ),
		'BD-60' => __( 'Sylhet' ),
		'BD-63' => __( 'Tangail' ),
		'BD-64' => __( 'Thakurgaon' ),
	),
	'BE' => array(),
	'BG' => array( // Bulgarian states.
		'BG-01' => __( 'Blagoevgrad' ),
		'BG-02' => __( 'Burgas' ),
		'BG-08' => __( 'Dobrich' ),
		'BG-07' => __( 'Gabrovo' ),
		'BG-26' => __( 'Haskovo' ),
		'BG-09' => __( 'Kardzhali' ),
		'BG-10' => __( 'Kyustendil' ),
		'BG-11' => __( 'Lovech' ),
		'BG-12' => __( 'Montana' ),
		'BG-13' => __( 'Pazardzhik' ),
		'BG-14' => __( 'Pernik' ),
		'BG-15' => __( 'Pleven' ),
		'BG-16' => __( 'Plovdiv' ),
		'BG-17' => __( 'Razgrad' ),
		'BG-18' => __( 'Ruse' ),
		'BG-27' => __( 'Shumen' ),
		'BG-19' => __( 'Silistra' ),
		'BG-20' => __( 'Sliven' ),
		'BG-21' => __( 'Smolyan' ),
		'BG-23' => __( 'Sofia' ),
		'BG-22' => __( 'Sofia-Grad' ),
		'BG-24' => __( 'Stara Zagora' ),
		'BG-25' => __( 'Targovishte' ),
		'BG-03' => __( 'Varna' ),
		'BG-04' => __( 'Veliko Tarnovo' ),
		'BG-05' => __( 'Vidin' ),
		'BG-06' => __( 'Vratsa' ),
		'BG-28' => __( 'Yambol' ),
	),
	'BH' => array(),
	'BI' => array(),
	'BO' => array( // Bolivian states.
		'B' => __( 'Chuquisaca' ),
		'H' => __( 'Beni' ),
		'C' => __( 'Cochabamba' ),
		'L' => __( 'La Paz' ),
		'O' => __( 'Oruro' ),
		'N' => __( 'Pando' ),
		'P' => __( 'Potosí' ),
		'S' => __( 'Santa Cruz' ),
		'T' => __( 'Tarija' ),
	),
	'BR' => array( // Brazillian states.
		'AC' => __( 'Acre' ),
		'AL' => __( 'Alagoas' ),
		'AP' => __( 'Amap&aacute;' ),
		'AM' => __( 'Amazonas' ),
		'BA' => __( 'Bahia' ),
		'CE' => __( 'Cear&aacute;' ),
		'DF' => __( 'Distrito Federal' ),
		'ES' => __( 'Esp&iacute;rito Santo' ),
		'GO' => __( 'Goi&aacute;s' ),
		'MA' => __( 'Maranh&atilde;o' ),
		'MT' => __( 'Mato Grosso' ),
		'MS' => __( 'Mato Grosso do Sul' ),
		'MG' => __( 'Minas Gerais' ),
		'PA' => __( 'Par&aacute;' ),
		'PB' => __( 'Para&iacute;ba' ),
		'PR' => __( 'Paran&aacute;' ),
		'PE' => __( 'Pernambuco' ),
		'PI' => __( 'Piau&iacute;' ),
		'RJ' => __( 'Rio de Janeiro' ),
		'RN' => __( 'Rio Grande do Norte' ),
		'RS' => __( 'Rio Grande do Sul' ),
		'RO' => __( 'Rond&ocirc;nia' ),
		'RR' => __( 'Roraima' ),
		'SC' => __( 'Santa Catarina' ),
		'SP' => __( 'S&atilde;o Paulo' ),
		'SE' => __( 'Sergipe' ),
		'TO' => __( 'Tocantins' ),
	),
	'CA' => array( // Canadian states.
		'AB' => __( 'Alberta' ),
		'BC' => __( 'British Columbia' ),
		'MB' => __( 'Manitoba' ),
		'NB' => __( 'New Brunswick' ),
		'NL' => __( 'Newfoundland and Labrador' ),
		'NT' => __( 'Northwest Territories' ),
		'NS' => __( 'Nova Scotia' ),
		'NU' => __( 'Nunavut' ),
		'ON' => __( 'Ontario' ),
		'PE' => __( 'Prince Edward Island' ),
		'QC' => __( 'Quebec' ),
		'SK' => __( 'Saskatchewan' ),
		'YT' => __( 'Yukon Territory' ),
	),
	'CH' => array( // Cantons of Switzerland.
		'AG' => __( 'Aargau' ),
		'AR' => __( 'Appenzell Ausserrhoden' ),
		'AI' => __( 'Appenzell Innerrhoden' ),
		'BL' => __( 'Basel-Landschaft' ),
		'BS' => __( 'Basel-Stadt' ),
		'BE' => __( 'Bern' ),
		'FR' => __( 'Fribourg' ),
		'GE' => __( 'Geneva' ),
		'GL' => __( 'Glarus' ),
		'GR' => __( 'Graub&uuml;nden' ),
		'JU' => __( 'Jura' ),
		'LU' => __( 'Luzern' ),
		'NE' => __( 'Neuch&acirc;tel' ),
		'NW' => __( 'Nidwalden' ),
		'OW' => __( 'Obwalden' ),
		'SH' => __( 'Schaffhausen' ),
		'SZ' => __( 'Schwyz' ),
		'SO' => __( 'Solothurn' ),
		'SG' => __( 'St. Gallen' ),
		'TG' => __( 'Thurgau' ),
		'TI' => __( 'Ticino' ),
		'UR' => __( 'Uri' ),
		'VS' => __( 'Valais' ),
		'VD' => __( 'Vaud' ),
		'ZG' => __( 'Zug' ),
		'ZH' => __( 'Z&uuml;rich' ),
	),
	'CN' => array( // Chinese states.
		'CN1'  => __( 'Yunnan / &#20113;&#21335;' ),
		'CN2'  => __( 'Beijing / &#21271;&#20140;' ),
		'CN3'  => __( 'Tianjin / &#22825;&#27941;' ),
		'CN4'  => __( 'Hebei / &#27827;&#21271;' ),
		'CN5'  => __( 'Shanxi / &#23665;&#35199;' ),
		'CN6'  => __( 'Inner Mongolia / &#20839;&#33945;&#21476;' ),
		'CN7'  => __( 'Liaoning / &#36797;&#23425;' ),
		'CN8'  => __( 'Jilin / &#21513;&#26519;' ),
		'CN9'  => __( 'Heilongjiang / &#40657;&#40857;&#27743;' ),
		'CN10' => __( 'Shanghai / &#19978;&#28023;' ),
		'CN11' => __( 'Jiangsu / &#27743;&#33487;' ),
		'CN12' => __( 'Zhejiang / &#27993;&#27743;' ),
		'CN13' => __( 'Anhui / &#23433;&#24509;' ),
		'CN14' => __( 'Fujian / &#31119;&#24314;' ),
		'CN15' => __( 'Jiangxi / &#27743;&#35199;' ),
		'CN16' => __( 'Shandong / &#23665;&#19996;' ),
		'CN17' => __( 'Henan / &#27827;&#21335;' ),
		'CN18' => __( 'Hubei / &#28246;&#21271;' ),
		'CN19' => __( 'Hunan / &#28246;&#21335;' ),
		'CN20' => __( 'Guangdong / &#24191;&#19996;' ),
		'CN21' => __( 'Guangxi Zhuang / &#24191;&#35199;&#22766;&#26063;' ),
		'CN22' => __( 'Hainan / &#28023;&#21335;' ),
		'CN23' => __( 'Chongqing / &#37325;&#24198;' ),
		'CN24' => __( 'Sichuan / &#22235;&#24029;' ),
		'CN25' => __( 'Guizhou / &#36149;&#24030;' ),
		'CN26' => __( 'Shaanxi / &#38485;&#35199;' ),
		'CN27' => __( 'Gansu / &#29976;&#32899;' ),
		'CN28' => __( 'Qinghai / &#38738;&#28023;' ),
		'CN29' => __( 'Ningxia Hui / &#23425;&#22799;' ),
		'CN30' => __( 'Macau / &#28595;&#38376;' ),
		'CN31' => __( 'Tibet / &#35199;&#34255;' ),
		'CN32' => __( 'Xinjiang / &#26032;&#30086;' ),
	),
	'CZ' => array(),
	'DE' => array(),
	'DK' => array(),
	'EE' => array(),
	'ES' => array( // Spanish states.
		'C'  => __( 'A Coru&ntilde;a' ),
		'VI' => __( 'Araba/&Aacute;lava' ),
		'AB' => __( 'Albacete' ),
		'A'  => __( 'Alicante' ),
		'AL' => __( 'Almer&iacute;a' ),
		'O'  => __( 'Asturias' ),
		'AV' => __( '&Aacute;vila' ),
		'BA' => __( 'Badajoz' ),
		'PM' => __( 'Baleares' ),
		'B'  => __( 'Barcelona' ),
		'BU' => __( 'Burgos' ),
		'CC' => __( 'C&aacute;ceres' ),
		'CA' => __( 'C&aacute;diz' ),
		'S'  => __( 'Cantabria' ),
		'CS' => __( 'Castell&oacute;n' ),
		'CE' => __( 'Ceuta' ),
		'CR' => __( 'Ciudad Real' ),
		'CO' => __( 'C&oacute;rdoba' ),
		'CU' => __( 'Cuenca' ),
		'GI' => __( 'Girona' ),
		'GR' => __( 'Granada' ),
		'GU' => __( 'Guadalajara' ),
		'SS' => __( 'Gipuzkoa' ),
		'H'  => __( 'Huelva' ),
		'HU' => __( 'Huesca' ),
		'J'  => __( 'Ja&eacute;n' ),
		'LO' => __( 'La Rioja' ),
		'GC' => __( 'Las Palmas' ),
		'LE' => __( 'Le&oacute;n' ),
		'L'  => __( 'Lleida' ),
		'LU' => __( 'Lugo' ),
		'M'  => __( 'Madrid' ),
		'MA' => __( 'M&aacute;laga' ),
		'ML' => __( 'Melilla' ),
		'MU' => __( 'Murcia' ),
		'NA' => __( 'Navarra' ),
		'OR' => __( 'Ourense' ),
		'P'  => __( 'Palencia' ),
		'PO' => __( 'Pontevedra' ),
		'SA' => __( 'Salamanca' ),
		'TF' => __( 'Santa Cruz de Tenerife' ),
		'SG' => __( 'Segovia' ),
		'SE' => __( 'Sevilla' ),
		'SO' => __( 'Soria' ),
		'T'  => __( 'Tarragona' ),
		'TE' => __( 'Teruel' ),
		'TO' => __( 'Toledo' ),
		'V'  => __( 'Valencia' ),
		'VA' => __( 'Valladolid' ),
		'BI' => __( 'Bizkaia' ),
		'ZA' => __( 'Zamora' ),
		'Z'  => __( 'Zaragoza' ),
	),
	'FI' => array(),
	'FR' => array(),
	'GP' => array(),
	'GR' => array( // Greek Regions.
		'I' => __( 'Αττική' ),
		'A' => __( 'Ανατολική Μακεδονία και Θράκη' ),
		'B' => __( 'Κεντρική Μακεδονία' ),
		'C' => __( 'Δυτική Μακεδονία' ),
		'D' => __( 'Ήπειρος' ),
		'E' => __( 'Θεσσαλία' ),
		'F' => __( 'Ιόνιοι Νήσοι' ),
		'G' => __( 'Δυτική Ελλάδα' ),
		'H' => __( 'Στερεά Ελλάδα' ),
		'J' => __( 'Πελοπόννησος' ),
		'K' => __( 'Βόρειο Αιγαίο' ),
		'L' => __( 'Νότιο Αιγαίο' ),
		'M' => __( 'Κρήτη' ),
	),
	'GF' => array(),
	'HK' => array( // Hong Kong states.
		'HONG KONG'       => __( 'Hong Kong Island' ),
		'KOWLOON'         => __( 'Kowloon' ),
		'NEW TERRITORIES' => __( 'New Territories' ),
	),
	'HU' => array( // Hungary states.
		'BK' => __( 'Bács-Kiskun' ),
		'BE' => __( 'Békés' ),
		'BA' => __( 'Baranya' ),
		'BZ' => __( 'Borsod-Abaúj-Zemplén' ),
		'BU' => __( 'Budapest' ),
		'CS' => __( 'Csongrád' ),
		'FE' => __( 'Fejér' ),
		'GS' => __( 'Győr-Moson-Sopron' ),
		'HB' => __( 'Hajdú-Bihar' ),
		'HE' => __( 'Heves' ),
		'JN' => __( 'Jász-Nagykun-Szolnok' ),
		'KE' => __( 'Komárom-Esztergom' ),
		'NO' => __( 'Nógrád' ),
		'PE' => __( 'Pest' ),
		'SO' => __( 'Somogy' ),
		'SZ' => __( 'Szabolcs-Szatmár-Bereg' ),
		'TO' => __( 'Tolna' ),
		'VA' => __( 'Vas' ),
		'VE' => __( 'Veszprém' ),
		'ZA' => __( 'Zala' ),
	),
	'ID' => array( // Indonesia Provinces.
		'AC' => __( 'Daerah Istimewa Aceh' ),
		'SU' => __( 'Sumatera Utara' ),
		'SB' => __( 'Sumatera Barat' ),
		'RI' => __( 'Riau' ),
		'KR' => __( 'Kepulauan Riau' ),
		'JA' => __( 'Jambi' ),
		'SS' => __( 'Sumatera Selatan' ),
		'BB' => __( 'Bangka Belitung' ),
		'BE' => __( 'Bengkulu' ),
		'LA' => __( 'Lampung' ),
		'JK' => __( 'DKI Jakarta' ),
		'JB' => __( 'Jawa Barat' ),
		'BT' => __( 'Banten' ),
		'JT' => __( 'Jawa Tengah' ),
		'JI' => __( 'Jawa Timur' ),
		'YO' => __( 'Daerah Istimewa Yogyakarta' ),
		'BA' => __( 'Bali' ),
		'NB' => __( 'Nusa Tenggara Barat' ),
		'NT' => __( 'Nusa Tenggara Timur' ),
		'KB' => __( 'Kalimantan Barat' ),
		'KT' => __( 'Kalimantan Tengah' ),
		'KI' => __( 'Kalimantan Timur' ),
		'KS' => __( 'Kalimantan Selatan' ),
		'KU' => __( 'Kalimantan Utara' ),
		'SA' => __( 'Sulawesi Utara' ),
		'ST' => __( 'Sulawesi Tengah' ),
		'SG' => __( 'Sulawesi Tenggara' ),
		'SR' => __( 'Sulawesi Barat' ),
		'SN' => __( 'Sulawesi Selatan' ),
		'GO' => __( 'Gorontalo' ),
		'MA' => __( 'Maluku' ),
		'MU' => __( 'Maluku Utara' ),
		'PA' => __( 'Papua' ),
		'PB' => __( 'Papua Barat' ),
	),
	'IE' => array( // Republic of Ireland.
		'CW' => __( 'Carlow' ),
		'CN' => __( 'Cavan' ),
		'CE' => __( 'Clare' ),
		'CO' => __( 'Cork' ),
		'DL' => __( 'Donegal' ),
		'D'  => __( 'Dublin' ),
		'G'  => __( 'Galway' ),
		'KY' => __( 'Kerry' ),
		'KE' => __( 'Kildare' ),
		'KK' => __( 'Kilkenny' ),
		'LS' => __( 'Laois' ),
		'LM' => __( 'Leitrim' ),
		'LK' => __( 'Limerick' ),
		'LD' => __( 'Longford' ),
		'LH' => __( 'Louth' ),
		'MO' => __( 'Mayo' ),
		'MH' => __( 'Meath' ),
		'MN' => __( 'Monaghan' ),
		'OY' => __( 'Offaly' ),
		'RN' => __( 'Roscommon' ),
		'SO' => __( 'Sligo' ),
		'TA' => __( 'Tipperary' ),
		'WD' => __( 'Waterford' ),
		'WH' => __( 'Westmeath' ),
		'WX' => __( 'Wexford' ),
		'WW' => __( 'Wicklow' ),
	),
	'IN' => array( // Indian states.
		'AP' => __( 'Andhra Pradesh' ),
		'AR' => __( 'Arunachal Pradesh' ),
		'AS' => __( 'Assam' ),
		'BR' => __( 'Bihar' ),
		'CT' => __( 'Chhattisgarh' ),
		'GA' => __( 'Goa' ),
		'GJ' => __( 'Gujarat' ),
		'HR' => __( 'Haryana' ),
		'HP' => __( 'Himachal Pradesh' ),
		'JK' => __( 'Jammu and Kashmir' ),
		'JH' => __( 'Jharkhand' ),
		'KA' => __( 'Karnataka' ),
		'KL' => __( 'Kerala' ),
		'MP' => __( 'Madhya Pradesh' ),
		'MH' => __( 'Maharashtra' ),
		'MN' => __( 'Manipur' ),
		'ML' => __( 'Meghalaya' ),
		'MZ' => __( 'Mizoram' ),
		'NL' => __( 'Nagaland' ),
		'OR' => __( 'Orissa' ),
		'PB' => __( 'Punjab' ),
		'RJ' => __( 'Rajasthan' ),
		'SK' => __( 'Sikkim' ),
		'TN' => __( 'Tamil Nadu' ),
		'TS' => __( 'Telangana' ),
		'TR' => __( 'Tripura' ),
		'UK' => __( 'Uttarakhand' ),
		'UP' => __( 'Uttar Pradesh' ),
		'WB' => __( 'West Bengal' ),
		'AN' => __( 'Andaman and Nicobar Islands' ),
		'CH' => __( 'Chandigarh' ),
		'DN' => __( 'Dadra and Nagar Haveli' ),
		'DD' => __( 'Daman and Diu' ),
		'DL' => __( 'Delhi' ),
		'LD' => __( 'Lakshadeep' ),
		'PY' => __( 'Pondicherry (Puducherry)' ),
	),
	'IR' => array( // Iran States.
		'KHZ' => __( 'Khuzestan  (خوزستان)' ),
		'THR' => __( 'Tehran  (تهران)' ),
		'ILM' => __( 'Ilaam (ایلام)' ),
		'BHR' => __( 'Bushehr (بوشهر)' ),
		'ADL' => __( 'Ardabil (اردبیل)' ),
		'ESF' => __( 'Isfahan (اصفهان)' ),
		'YZD' => __( 'Yazd (یزد)' ),
		'KRH' => __( 'Kermanshah (کرمانشاه)' ),
		'KRN' => __( 'Kerman (کرمان)' ),
		'HDN' => __( 'Hamadan (همدان)' ),
		'GZN' => __( 'Ghazvin (قزوین)' ),
		'ZJN' => __( 'Zanjan (زنجان)' ),
		'LRS' => __( 'Luristan (لرستان)' ),
		'ABZ' => __( 'Alborz (البرز)' ),
		'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)' ),
		'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)' ),
		'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)' ),
		'SKH' => __( 'South Khorasan (خراسان جنوبی)' ),
		'RKH' => __( 'Razavi Khorasan (خراسان رضوی)' ),
		'NKH' => __( 'North Khorasan (خراسان شمالی)' ),
		'SMN' => __( 'Semnan (سمنان)' ),
		'FRS' => __( 'Fars (فارس)' ),
		'QHM' => __( 'Qom (قم)' ),
		'KRD' => __( 'Kurdistan / کردستان)' ),
		'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)' ),
		'GLS' => __( 'Golestan (گلستان)' ),
		'GIL' => __( 'Gilan (گیلان)' ),
		'MZN' => __( 'Mazandaran (مازندران)' ),
		'MKZ' => __( 'Markazi (مرکزی)' ),
		'HRZ' => __( 'Hormozgan (هرمزگان)' ),
		'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)' ),
	),
	'IS' => array(),
	'IT' => array( // Italy Provinces.
		'AG' => __( 'Agrigento' ),
		'AL' => __( 'Alessandria' ),
		'AN' => __( 'Ancona' ),
		'AO' => __( 'Aosta' ),
		'AR' => __( 'Arezzo' ),
		'AP' => __( 'Ascoli Piceno' ),
		'AT' => __( 'Asti' ),
		'AV' => __( 'Avellino' ),
		'BA' => __( 'Bari' ),
		'BT' => __( 'Barletta-Andria-Trani' ),
		'BL' => __( 'Belluno' ),
		'BN' => __( 'Benevento' ),
		'BG' => __( 'Bergamo' ),
		'BI' => __( 'Biella' ),
		'BO' => __( 'Bologna' ),
		'BZ' => __( 'Bolzano' ),
		'BS' => __( 'Brescia' ),
		'BR' => __( 'Brindisi' ),
		'CA' => __( 'Cagliari' ),
		'CL' => __( 'Caltanissetta' ),
		'CB' => __( 'Campobasso' ),
		'CE' => __( 'Caserta' ),
		'CT' => __( 'Catania' ),
		'CZ' => __( 'Catanzaro' ),
		'CH' => __( 'Chieti' ),
		'CO' => __( 'Como' ),
		'CS' => __( 'Cosenza' ),
		'CR' => __( 'Cremona' ),
		'KR' => __( 'Crotone' ),
		'CN' => __( 'Cuneo' ),
		'EN' => __( 'Enna' ),
		'FM' => __( 'Fermo' ),
		'FE' => __( 'Ferrara' ),
		'FI' => __( 'Firenze' ),
		'FG' => __( 'Foggia' ),
		'FC' => __( 'Forlì-Cesena' ),
		'FR' => __( 'Frosinone' ),
		'GE' => __( 'Genova' ),
		'GO' => __( 'Gorizia' ),
		'GR' => __( 'Grosseto' ),
		'IM' => __( 'Imperia' ),
		'IS' => __( 'Isernia' ),
		'SP' => __( 'La Spezia' ),
		'AQ' => __( "L'Aquila" ),
		'LT' => __( 'Latina' ),
		'LE' => __( 'Lecce' ),
		'LC' => __( 'Lecco' ),
		'LI' => __( 'Livorno' ),
		'LO' => __( 'Lodi' ),
		'LU' => __( 'Lucca' ),
		'MC' => __( 'Macerata' ),
		'MN' => __( 'Mantova' ),
		'MS' => __( 'Massa-Carrara' ),
		'MT' => __( 'Matera' ),
		'ME' => __( 'Messina' ),
		'MI' => __( 'Milano' ),
		'MO' => __( 'Modena' ),
		'MB' => __( 'Monza e della Brianza' ),
		'NA' => __( 'Napoli' ),
		'NO' => __( 'Novara' ),
		'NU' => __( 'Nuoro' ),
		'OR' => __( 'Oristano' ),
		'PD' => __( 'Padova' ),
		'PA' => __( 'Palermo' ),
		'PR' => __( 'Parma' ),
		'PV' => __( 'Pavia' ),
		'PG' => __( 'Perugia' ),
		'PU' => __( 'Pesaro e Urbino' ),
		'PE' => __( 'Pescara' ),
		'PC' => __( 'Piacenza' ),
		'PI' => __( 'Pisa' ),
		'PT' => __( 'Pistoia' ),
		'PN' => __( 'Pordenone' ),
		'PZ' => __( 'Potenza' ),
		'PO' => __( 'Prato' ),
		'RG' => __( 'Ragusa' ),
		'RA' => __( 'Ravenna' ),
		'RC' => __( 'Reggio Calabria' ),
		'RE' => __( 'Reggio Emilia' ),
		'RI' => __( 'Rieti' ),
		'RN' => __( 'Rimini' ),
		'RM' => __( 'Roma' ),
		'RO' => __( 'Rovigo' ),
		'SA' => __( 'Salerno' ),
		'SS' => __( 'Sassari' ),
		'SV' => __( 'Savona' ),
		'SI' => __( 'Siena' ),
		'SR' => __( 'Siracusa' ),
		'SO' => __( 'Sondrio' ),
		'SU' => __( 'Sud Sardegna' ),
		'TA' => __( 'Taranto' ),
		'TE' => __( 'Teramo' ),
		'TR' => __( 'Terni' ),
		'TO' => __( 'Torino' ),
		'TP' => __( 'Trapani' ),
		'TN' => __( 'Trento' ),
		'TV' => __( 'Treviso' ),
		'TS' => __( 'Trieste' ),
		'UD' => __( 'Udine' ),
		'VA' => __( 'Varese' ),
		'VE' => __( 'Venezia' ),
		'VB' => __( 'Verbano-Cusio-Ossola' ),
		'VC' => __( 'Vercelli' ),
		'VR' => __( 'Verona' ),
		'VV' => __( 'Vibo Valentia' ),
		'VI' => __( 'Vicenza' ),
		'VT' => __( 'Viterbo' ),
	),
	'IL' => array(),
	'IM' => array(),

	/**
	 * Japan States.
	 *
	 * English notation of prefectures conform to the notation of Japan Post.
	 * The suffix corresponds with the Japanese translation file.
	 */
	'JP' => array(
		'JP01' => __( 'Hokkaido' ),
		'JP02' => __( 'Aomori' ),
		'JP03' => __( 'Iwate' ),
		'JP04' => __( 'Miyagi' ),
		'JP05' => __( 'Akita' ),
		'JP06' => __( 'Yamagata' ),
		'JP07' => __( 'Fukushima' ),
		'JP08' => __( 'Ibaraki' ),
		'JP09' => __( 'Tochigi' ),
		'JP10' => __( 'Gunma' ),
		'JP11' => __( 'Saitama' ),
		'JP12' => __( 'Chiba' ),
		'JP13' => __( 'Tokyo' ),
		'JP14' => __( 'Kanagawa' ),
		'JP15' => __( 'Niigata' ),
		'JP16' => __( 'Toyama' ),
		'JP17' => __( 'Ishikawa' ),
		'JP18' => __( 'Fukui' ),
		'JP19' => __( 'Yamanashi' ),
		'JP20' => __( 'Nagano' ),
		'JP21' => __( 'Gifu' ),
		'JP22' => __( 'Shizuoka' ),
		'JP23' => __( 'Aichi' ),
		'JP24' => __( 'Mie' ),
		'JP25' => __( 'Shiga' ),
		'JP26' => __( 'Kyoto' ),
		'JP27' => __( 'Osaka' ),
		'JP28' => __( 'Hyogo' ),
		'JP29' => __( 'Nara' ),
		'JP30' => __( 'Wakayama' ),
		'JP31' => __( 'Tottori' ),
		'JP32' => __( 'Shimane' ),
		'JP33' => __( 'Okayama' ),
		'JP34' => __( 'Hiroshima' ),
		'JP35' => __( 'Yamaguchi' ),
		'JP36' => __( 'Tokushima' ),
		'JP37' => __( 'Kagawa' ),
		'JP38' => __( 'Ehime' ),
		'JP39' => __( 'Kochi' ),
		'JP40' => __( 'Fukuoka' ),
		'JP41' => __( 'Saga' ),
		'JP42' => __( 'Nagasaki' ),
		'JP43' => __( 'Kumamoto' ),
		'JP44' => __( 'Oita' ),
		'JP45' => __( 'Miyazaki' ),
		'JP46' => __( 'Kagoshima' ),
		'JP47' => __( 'Okinawa' ),
	),
	'KR' => array(),
	'KW' => array(),
	'LB' => array(),
	'LR' => array( // Liberia provinces.
		'BM' => __( 'Bomi' ),
		'BN' => __( 'Bong' ),
		'GA' => __( 'Gbarpolu' ),
		'GB' => __( 'Grand Bassa' ),
		'GC' => __( 'Grand Cape Mount' ),
		'GG' => __( 'Grand Gedeh' ),
		'GK' => __( 'Grand Kru' ),
		'LO' => __( 'Lofa' ),
		'MA' => __( 'Margibi' ),
		'MY' => __( 'Maryland' ),
		'MO' => __( 'Montserrado' ),
		'NM' => __( 'Nimba' ),
		'RV' => __( 'Rivercess' ),
		'RG' => __( 'River Gee' ),
		'SN' => __( 'Sinoe' ),
	),
	'LU' => array(),
	'MD' => array( // Moldova states.
		'C'  => __( 'Chi&#537;in&#259;u' ),
		'BL' => __( 'B&#259;l&#539;i' ),
		'AN' => __( 'Anenii Noi' ),
		'BS' => __( 'Basarabeasca' ),
		'BR' => __( 'Briceni' ),
		'CH' => __( 'Cahul' ),
		'CT' => __( 'Cantemir' ),
		'CL' => __( 'C&#259;l&#259;ra&#537;i' ),
		'CS' => __( 'C&#259;u&#537;eni' ),
		'CM' => __( 'Cimi&#537;lia' ),
		'CR' => __( 'Criuleni' ),
		'DN' => __( 'Dondu&#537;eni' ),
		'DR' => __( 'Drochia' ),
		'DB' => __( 'Dub&#259;sari' ),
		'ED' => __( 'Edine&#539;' ),
		'FL' => __( 'F&#259;le&#537;ti' ),
		'FR' => __( 'Flore&#537;ti' ),
		'GE' => __( 'UTA G&#259;g&#259;uzia' ),
		'GL' => __( 'Glodeni' ),
		'HN' => __( 'H&icirc;nce&#537;ti' ),
		'IL' => __( 'Ialoveni' ),
		'LV' => __( 'Leova' ),
		'NS' => __( 'Nisporeni' ),
		'OC' => __( 'Ocni&#539;a' ),
		'OR' => __( 'Orhei' ),
		'RZ' => __( 'Rezina' ),
		'RS' => __( 'R&icirc;&#537;cani' ),
		'SG' => __( 'S&icirc;ngerei' ),
		'SR' => __( 'Soroca' ),
		'ST' => __( 'Str&#259;&#537;eni' ),
		'SD' => __( '&#536;old&#259;ne&#537;ti' ),
		'SV' => __( '&#536;tefan Vod&#259;' ),
		'TR' => __( 'Taraclia' ),
		'TL' => __( 'Telene&#537;ti' ),
		'UN' => __( 'Ungheni' ),
	),
	'MQ' => array(),
	'MT' => array(),
	'MX' => array( // Mexico States.
		'DF' => __( 'Ciudad de M&eacute;xico' ),
		'JA' => __( 'Jalisco' ),
		'NL' => __( 'Nuevo Le&oacute;n' ),
		'AG' => __( 'Aguascalientes' ),
		'BC' => __( 'Baja California' ),
		'BS' => __( 'Baja California Sur' ),
		'CM' => __( 'Campeche' ),
		'CS' => __( 'Chiapas' ),
		'CH' => __( 'Chihuahua' ),
		'CO' => __( 'Coahuila' ),
		'CL' => __( 'Colima' ),
		'DG' => __( 'Durango' ),
		'GT' => __( 'Guanajuato' ),
		'GR' => __( 'Guerrero' ),
		'HG' => __( 'Hidalgo' ),
		'MX' => __( 'Estado de M&eacute;xico' ),
		'MI' => __( 'Michoac&aacute;n' ),
		'MO' => __( 'Morelos' ),
		'NA' => __( 'Nayarit' ),
		'OA' => __( 'Oaxaca' ),
		'PU' => __( 'Puebla' ),
		'QT' => __( 'Quer&eacute;taro' ),
		'QR' => __( 'Quintana Roo' ),
		'SL' => __( 'San Luis Potos&iacute;' ),
		'SI' => __( 'Sinaloa' ),
		'SO' => __( 'Sonora' ),
		'TB' => __( 'Tabasco' ),
		'TM' => __( 'Tamaulipas' ),
		'TL' => __( 'Tlaxcala' ),
		'VE' => __( 'Veracruz' ),
		'YU' => __( 'Yucat&aacute;n' ),
		'ZA' => __( 'Zacatecas' ),
	),
	'MY' => array( // Malaysian states.
		'JHR' => __( 'Johor' ),
		'KDH' => __( 'Kedah' ),
		'KTN' => __( 'Kelantan' ),
		'LBN' => __( 'Labuan' ),
		'MLK' => __( 'Malacca (Melaka)' ),
		'NSN' => __( 'Negeri Sembilan' ),
		'PHG' => __( 'Pahang' ),
		'PNG' => __( 'Penang (Pulau Pinang)' ),
		'PRK' => __( 'Perak' ),
		'PLS' => __( 'Perlis' ),
		'SBH' => __( 'Sabah' ),
		'SWK' => __( 'Sarawak' ),
		'SGR' => __( 'Selangor' ),
		'TRG' => __( 'Terengganu' ),
		'PJY' => __( 'Putrajaya' ),
		'KUL' => __( 'Kuala Lumpur' ),
	),
	'NG' => array( // Nigerian provinces.
		'AB' => __( 'Abia' ),
		'FC' => __( 'Abuja' ),
		'AD' => __( 'Adamawa' ),
		'AK' => __( 'Akwa Ibom' ),
		'AN' => __( 'Anambra' ),
		'BA' => __( 'Bauchi' ),
		'BY' => __( 'Bayelsa' ),
		'BE' => __( 'Benue' ),
		'BO' => __( 'Borno' ),
		'CR' => __( 'Cross River' ),
		'DE' => __( 'Delta' ),
		'EB' => __( 'Ebonyi' ),
		'ED' => __( 'Edo' ),
		'EK' => __( 'Ekiti' ),
		'EN' => __( 'Enugu' ),
		'GO' => __( 'Gombe' ),
		'IM' => __( 'Imo' ),
		'JI' => __( 'Jigawa' ),
		'KD' => __( 'Kaduna' ),
		'KN' => __( 'Kano' ),
		'KT' => __( 'Katsina' ),
		'KE' => __( 'Kebbi' ),
		'KO' => __( 'Kogi' ),
		'KW' => __( 'Kwara' ),
		'LA' => __( 'Lagos' ),
		'NA' => __( 'Nasarawa' ),
		'NI' => __( 'Niger' ),
		'OG' => __( 'Ogun' ),
		'ON' => __( 'Ondo' ),
		'OS' => __( 'Osun' ),
		'OY' => __( 'Oyo' ),
		'PL' => __( 'Plateau' ),
		'RI' => __( 'Rivers' ),
		'SO' => __( 'Sokoto' ),
		'TA' => __( 'Taraba' ),
		'YO' => __( 'Yobe' ),
		'ZA' => __( 'Zamfara' ),
	),
	'NL' => array(),
	'NO' => array(),
	'NP' => array( // Nepal states (Zones).
		'BAG' => __( 'Bagmati' ),
		'BHE' => __( 'Bheri' ),
		'DHA' => __( 'Dhaulagiri' ),
		'GAN' => __( 'Gandaki' ),
		'JAN' => __( 'Janakpur' ),
		'KAR' => __( 'Karnali' ),
		'KOS' => __( 'Koshi' ),
		'LUM' => __( 'Lumbini' ),
		'MAH' => __( 'Mahakali' ),
		'MEC' => __( 'Mechi' ),
		'NAR' => __( 'Narayani' ),
		'RAP' => __( 'Rapti' ),
		'SAG' => __( 'Sagarmatha' ),
		'SET' => __( 'Seti' ),
	),
	'NZ' => array( // New Zealand States.
		'NL' => __( 'Northland' ),
		'AK' => __( 'Auckland' ),
		'WA' => __( 'Waikato' ),
		'BP' => __( 'Bay of Plenty' ),
		'TK' => __( 'Taranaki' ),
		'GI' => __( 'Gisborne' ),
		'HB' => __( 'Hawke&rsquo;s Bay' ),
		'MW' => __( 'Manawatu-Wanganui' ),
		'WE' => __( 'Wellington' ),
		'NS' => __( 'Nelson' ),
		'MB' => __( 'Marlborough' ),
		'TM' => __( 'Tasman' ),
		'WC' => __( 'West Coast' ),
		'CT' => __( 'Canterbury' ),
		'OT' => __( 'Otago' ),
		'SL' => __( 'Southland' ),
	),
	'PE' => array( // Peru states.
		'CAL' => __( 'El Callao' ),
		'LMA' => __( 'Municipalidad Metropolitana de Lima' ),
		'AMA' => __( 'Amazonas' ),
		'ANC' => __( 'Ancash' ),
		'APU' => __( 'Apur&iacute;mac' ),
		'ARE' => __( 'Arequipa' ),
		'AYA' => __( 'Ayacucho' ),
		'CAJ' => __( 'Cajamarca' ),
		'CUS' => __( 'Cusco' ),
		'HUV' => __( 'Huancavelica' ),
		'HUC' => __( 'Hu&aacute;nuco' ),
		'ICA' => __( 'Ica' ),
		'JUN' => __( 'Jun&iacute;n' ),
		'LAL' => __( 'La Libertad' ),
		'LAM' => __( 'Lambayeque' ),
		'LIM' => __( 'Lima' ),
		'LOR' => __( 'Loreto' ),
		'MDD' => __( 'Madre de Dios' ),
		'MOQ' => __( 'Moquegua' ),
		'PAS' => __( 'Pasco' ),
		'PIU' => __( 'Piura' ),
		'PUN' => __( 'Puno' ),
		'SAM' => __( 'San Mart&iacute;n' ),
		'TAC' => __( 'Tacna' ),
		'TUM' => __( 'Tumbes' ),
		'UCA' => __( 'Ucayali' ),
	),

	/**
	 * Philippine Provinces.
	 *
	 * @todo DAC Needs to be updated when ISO code is assigned.
	 */
	'PH' => array(
		'ABR' => __( 'Abra' ),
		'AGN' => __( 'Agusan del Norte' ),
		'AGS' => __( 'Agusan del Sur' ),
		'AKL' => __( 'Aklan' ),
		'ALB' => __( 'Albay' ),
		'ANT' => __( 'Antique' ),
		'APA' => __( 'Apayao' ),
		'AUR' => __( 'Aurora' ),
		'BAS' => __( 'Basilan' ),
		'BAN' => __( 'Bataan' ),
		'BTN' => __( 'Batanes' ),
		'BTG' => __( 'Batangas' ),
		'BEN' => __( 'Benguet' ),
		'BIL' => __( 'Biliran' ),
		'BOH' => __( 'Bohol' ),
		'BUK' => __( 'Bukidnon' ),
		'BUL' => __( 'Bulacan' ),
		'CAG' => __( 'Cagayan' ),
		'CAN' => __( 'Camarines Norte' ),
		'CAS' => __( 'Camarines Sur' ),
		'CAM' => __( 'Camiguin' ),
		'CAP' => __( 'Capiz' ),
		'CAT' => __( 'Catanduanes' ),
		'CAV' => __( 'Cavite' ),
		'CEB' => __( 'Cebu' ),
		'COM' => __( 'Compostela Valley' ),
		'NCO' => __( 'Cotabato' ),
		'DAV' => __( 'Davao del Norte' ),
		'DAS' => __( 'Davao del Sur' ),
		'DAC' => __( 'Davao Occidental' ),
		'DAO' => __( 'Davao Oriental' ),
		'DIN' => __( 'Dinagat Islands' ),
		'EAS' => __( 'Eastern Samar' ),
		'GUI' => __( 'Guimaras' ),
		'IFU' => __( 'Ifugao' ),
		'ILN' => __( 'Ilocos Norte' ),
		'ILS' => __( 'Ilocos Sur' ),
		'ILI' => __( 'Iloilo' ),
		'ISA' => __( 'Isabela' ),
		'KAL' => __( 'Kalinga' ),
		'LUN' => __( 'La Union' ),
		'LAG' => __( 'Laguna' ),
		'LAN' => __( 'Lanao del Norte' ),
		'LAS' => __( 'Lanao del Sur' ),
		'LEY' => __( 'Leyte' ),
		'MAG' => __( 'Maguindanao' ),
		'MAD' => __( 'Marinduque' ),
		'MAS' => __( 'Masbate' ),
		'MSC' => __( 'Misamis Occidental' ),
		'MSR' => __( 'Misamis Oriental' ),
		'MOU' => __( 'Mountain Province' ),
		'NEC' => __( 'Negros Occidental' ),
		'NER' => __( 'Negros Oriental' ),
		'NSA' => __( 'Northern Samar' ),
		'NUE' => __( 'Nueva Ecija' ),
		'NUV' => __( 'Nueva Vizcaya' ),
		'MDC' => __( 'Occidental Mindoro' ),
		'MDR' => __( 'Oriental Mindoro' ),
		'PLW' => __( 'Palawan' ),
		'PAM' => __( 'Pampanga' ),
		'PAN' => __( 'Pangasinan' ),
		'QUE' => __( 'Quezon' ),
		'QUI' => __( 'Quirino' ),
		'RIZ' => __( 'Rizal' ),
		'ROM' => __( 'Romblon' ),
		'WSA' => __( 'Samar' ),
		'SAR' => __( 'Sarangani' ),
		'SIQ' => __( 'Siquijor' ),
		'SOR' => __( 'Sorsogon' ),
		'SCO' => __( 'South Cotabato' ),
		'SLE' => __( 'Southern Leyte' ),
		'SUK' => __( 'Sultan Kudarat' ),
		'SLU' => __( 'Sulu' ),
		'SUN' => __( 'Surigao del Norte' ),
		'SUR' => __( 'Surigao del Sur' ),
		'TAR' => __( 'Tarlac' ),
		'TAW' => __( 'Tawi-Tawi' ),
		'ZMB' => __( 'Zambales' ),
		'ZAN' => __( 'Zamboanga del Norte' ),
		'ZAS' => __( 'Zamboanga del Sur' ),
		'ZSI' => __( 'Zamboanga Sibugay' ),
		'00'  => __( 'Metro Manila' ),
	),
	'PK' => array( // Pakistan's states.
		'JK' => __( 'Azad Kashmir' ),
		'BA' => __( 'Balochistan' ),
		'TA' => __( 'FATA' ),
		'GB' => __( 'Gilgit Baltistan' ),
		'IS' => __( 'Islamabad Capital Territory' ),
		'KP' => __( 'Khyber Pakhtunkhwa' ),
		'PB' => __( 'Punjab' ),
		'SD' => __( 'Sindh' ),
	),
	'PL' => array(),
	'PT' => array(),
	'PY' => array( // Paraguay states.
		'PY-ASU' => __( 'Asunci&oacute;n' ),
		'PY-1'   => __( 'Concepci&oacute;n' ),
		'PY-2'   => __( 'San Pedro' ),
		'PY-3'   => __( 'Cordillera' ),
		'PY-4'   => __( 'Guair&aacute;' ),
		'PY-5'   => __( 'Caaguaz&uacute;' ),
		'PY-6'   => __( 'Caazap&aacute;' ),
		'PY-7'   => __( 'Itap&uacute;a' ),
		'PY-8'   => __( 'Misiones' ),
		'PY-9'   => __( 'Paraguar&iacute;' ),
		'PY-10'  => __( 'Alto Paran&aacute;' ),
		'PY-11'  => __( 'Central' ),
		'PY-12'  => __( '&Ntilde;eembuc&uacute;' ),
		'PY-13'  => __( 'Amambay' ),
		'PY-14'  => __( 'Canindey&uacute;' ),
		'PY-15'  => __( 'Presidente Hayes' ),
		'PY-16'  => __( 'Alto Paraguay' ),
		'PY-17'  => __( 'Boquer&oacute;n' ),
	),
	'RE' => array(),
	'RO' => array( // Romania states.
		'AB' => __( 'Alba' ),
		'AR' => __( 'Arad' ),
		'AG' => __( 'Arge&#537;' ),
		'BC' => __( 'Bac&#259;u' ),
		'BH' => __( 'Bihor' ),
		'BN' => __( 'Bistri&#539;a-N&#259;s&#259;ud' ),
		'BT' => __( 'Boto&#537;ani' ),
		'BR' => __( 'Br&#259;ila' ),
		'BV' => __( 'Bra&#537;ov' ),
		'B'  => __( 'Bucure&#537;ti' ),
		'BZ' => __( 'Buz&#259;u' ),
		'CL' => __( 'C&#259;l&#259;ra&#537;i' ),
		'CS' => __( 'Cara&#537;-Severin' ),
		'CJ' => __( 'Cluj' ),
		'CT' => __( 'Constan&#539;a' ),
		'CV' => __( 'Covasna' ),
		'DB' => __( 'D&acirc;mbovi&#539;a' ),
		'DJ' => __( 'Dolj' ),
		'GL' => __( 'Gala&#539;i' ),
		'GR' => __( 'Giurgiu' ),
		'GJ' => __( 'Gorj' ),
		'HR' => __( 'Harghita' ),
		'HD' => __( 'Hunedoara' ),
		'IL' => __( 'Ialomi&#539;a' ),
		'IS' => __( 'Ia&#537;i' ),
		'IF' => __( 'Ilfov' ),
		'MM' => __( 'Maramure&#537;' ),
		'MH' => __( 'Mehedin&#539;i' ),
		'MS' => __( 'Mure&#537;' ),
		'NT' => __( 'Neam&#539;' ),
		'OT' => __( 'Olt' ),
		'PH' => __( 'Prahova' ),
		'SJ' => __( 'S&#259;laj' ),
		'SM' => __( 'Satu Mare' ),
		'SB' => __( 'Sibiu' ),
		'SV' => __( 'Suceava' ),
		'TR' => __( 'Teleorman' ),
		'TM' => __( 'Timi&#537;' ),
		'TL' => __( 'Tulcea' ),
		'VL' => __( 'V&acirc;lcea' ),
		'VS' => __( 'Vaslui' ),
		'VN' => __( 'Vrancea' ),
	),
	'RS' => array(),
	'SG' => array(),
	'SK' => array(),
	'SI' => array(),
	'TH' => array( // Thailand states.
		'TH-37' => __( 'Amnat Charoen' ),
		'TH-15' => __( 'Ang Thong' ),
		'TH-14' => __( 'Ayutthaya' ),
		'TH-10' => __( 'Bangkok' ),
		'TH-38' => __( 'Bueng Kan' ),
		'TH-31' => __( 'Buri Ram' ),
		'TH-24' => __( 'Chachoengsao' ),
		'TH-18' => __( 'Chai Nat' ),
		'TH-36' => __( 'Chaiyaphum' ),
		'TH-22' => __( 'Chanthaburi' ),
		'TH-50' => __( 'Chiang Mai' ),
		'TH-57' => __( 'Chiang Rai' ),
		'TH-20' => __( 'Chonburi' ),
		'TH-86' => __( 'Chumphon' ),
		'TH-46' => __( 'Kalasin' ),
		'TH-62' => __( 'Kamphaeng Phet' ),
		'TH-71' => __( 'Kanchanaburi' ),
		'TH-40' => __( 'Khon Kaen' ),
		'TH-81' => __( 'Krabi' ),
		'TH-52' => __( 'Lampang' ),
		'TH-51' => __( 'Lamphun' ),
		'TH-42' => __( 'Loei' ),
		'TH-16' => __( 'Lopburi' ),
		'TH-58' => __( 'Mae Hong Son' ),
		'TH-44' => __( 'Maha Sarakham' ),
		'TH-49' => __( 'Mukdahan' ),
		'TH-26' => __( 'Nakhon Nayok' ),
		'TH-73' => __( 'Nakhon Pathom' ),
		'TH-48' => __( 'Nakhon Phanom' ),
		'TH-30' => __( 'Nakhon Ratchasima' ),
		'TH-60' => __( 'Nakhon Sawan' ),
		'TH-80' => __( 'Nakhon Si Thammarat' ),
		'TH-55' => __( 'Nan' ),
		'TH-96' => __( 'Narathiwat' ),
		'TH-39' => __( 'Nong Bua Lam Phu' ),
		'TH-43' => __( 'Nong Khai' ),
		'TH-12' => __( 'Nonthaburi' ),
		'TH-13' => __( 'Pathum Thani' ),
		'TH-94' => __( 'Pattani' ),
		'TH-82' => __( 'Phang Nga' ),
		'TH-93' => __( 'Phatthalung' ),
		'TH-56' => __( 'Phayao' ),
		'TH-67' => __( 'Phetchabun' ),
		'TH-76' => __( 'Phetchaburi' ),
		'TH-66' => __( 'Phichit' ),
		'TH-65' => __( 'Phitsanulok' ),
		'TH-54' => __( 'Phrae' ),
		'TH-83' => __( 'Phuket' ),
		'TH-25' => __( 'Prachin Buri' ),
		'TH-77' => __( 'Prachuap Khiri Khan' ),
		'TH-85' => __( 'Ranong' ),
		'TH-70' => __( 'Ratchaburi' ),
		'TH-21' => __( 'Rayong' ),
		'TH-45' => __( 'Roi Et' ),
		'TH-27' => __( 'Sa Kaeo' ),
		'TH-47' => __( 'Sakon Nakhon' ),
		'TH-11' => __( 'Samut Prakan' ),
		'TH-74' => __( 'Samut Sakhon' ),
		'TH-75' => __( 'Samut Songkhram' ),
		'TH-19' => __( 'Saraburi' ),
		'TH-91' => __( 'Satun' ),
		'TH-17' => __( 'Sing Buri' ),
		'TH-33' => __( 'Sisaket' ),
		'TH-90' => __( 'Songkhla' ),
		'TH-64' => __( 'Sukhothai' ),
		'TH-72' => __( 'Suphan Buri' ),
		'TH-84' => __( 'Surat Thani' ),
		'TH-32' => __( 'Surin' ),
		'TH-63' => __( 'Tak' ),
		'TH-92' => __( 'Trang' ),
		'TH-23' => __( 'Trat' ),
		'TH-34' => __( 'Ubon Ratchathani' ),
		'TH-41' => __( 'Udon Thani' ),
		'TH-61' => __( 'Uthai Thani' ),
		'TH-53' => __( 'Uttaradit' ),
		'TH-95' => __( 'Yala' ),
		'TH-35' => __( 'Yasothon' ),
	),
	'TR' => array( // Turkey States.
		'TR01' => __( 'Adana' ),
		'TR02' => __( 'Ad&#305;yaman' ),
		'TR03' => __( 'Afyon' ),
		'TR04' => __( 'A&#287;r&#305;' ),
		'TR05' => __( 'Amasya' ),
		'TR06' => __( 'Ankara' ),
		'TR07' => __( 'Antalya' ),
		'TR08' => __( 'Artvin' ),
		'TR09' => __( 'Ayd&#305;n' ),
		'TR10' => __( 'Bal&#305;kesir' ),
		'TR11' => __( 'Bilecik' ),
		'TR12' => __( 'Bing&#246;l' ),
		'TR13' => __( 'Bitlis' ),
		'TR14' => __( 'Bolu' ),
		'TR15' => __( 'Burdur' ),
		'TR16' => __( 'Bursa' ),
		'TR17' => __( '&#199;anakkale' ),
		'TR18' => __( '&#199;ank&#305;r&#305;' ),
		'TR19' => __( '&#199;orum' ),
		'TR20' => __( 'Denizli' ),
		'TR21' => __( 'Diyarbak&#305;r' ),
		'TR22' => __( 'Edirne' ),
		'TR23' => __( 'Elaz&#305;&#287;' ),
		'TR24' => __( 'Erzincan' ),
		'TR25' => __( 'Erzurum' ),
		'TR26' => __( 'Eski&#351;ehir' ),
		'TR27' => __( 'Gaziantep' ),
		'TR28' => __( 'Giresun' ),
		'TR29' => __( 'G&#252;m&#252;&#351;hane' ),
		'TR30' => __( 'Hakkari' ),
		'TR31' => __( 'Hatay' ),
		'TR32' => __( 'Isparta' ),
		'TR33' => __( '&#304;&#231;el' ),
		'TR34' => __( '&#304;stanbul' ),
		'TR35' => __( '&#304;zmir' ),
		'TR36' => __( 'Kars' ),
		'TR37' => __( 'Kastamonu' ),
		'TR38' => __( 'Kayseri' ),
		'TR39' => __( 'K&#305;rklareli' ),
		'TR40' => __( 'K&#305;r&#351;ehir' ),
		'TR41' => __( 'Kocaeli' ),
		'TR42' => __( 'Konya' ),
		'TR43' => __( 'K&#252;tahya' ),
		'TR44' => __( 'Malatya' ),
		'TR45' => __( 'Manisa' ),
		'TR46' => __( 'Kahramanmara&#351;' ),
		'TR47' => __( 'Mardin' ),
		'TR48' => __( 'Mu&#287;la' ),
		'TR49' => __( 'Mu&#351;' ),
		'TR50' => __( 'Nev&#351;ehir' ),
		'TR51' => __( 'Ni&#287;de' ),
		'TR52' => __( 'Ordu' ),
		'TR53' => __( 'Rize' ),
		'TR54' => __( 'Sakarya' ),
		'TR55' => __( 'Samsun' ),
		'TR56' => __( 'Siirt' ),
		'TR57' => __( 'Sinop' ),
		'TR58' => __( 'Sivas' ),
		'TR59' => __( 'Tekirda&#287;' ),
		'TR60' => __( 'Tokat' ),
		'TR61' => __( 'Trabzon' ),
		'TR62' => __( 'Tunceli' ),
		'TR63' => __( '&#350;anl&#305;urfa' ),
		'TR64' => __( 'U&#351;ak' ),
		'TR65' => __( 'Van' ),
		'TR66' => __( 'Yozgat' ),
		'TR67' => __( 'Zonguldak' ),
		'TR68' => __( 'Aksaray' ),
		'TR69' => __( 'Bayburt' ),
		'TR70' => __( 'Karaman' ),
		'TR71' => __( 'K&#305;r&#305;kkale' ),
		'TR72' => __( 'Batman' ),
		'TR73' => __( '&#350;&#305;rnak' ),
		'TR74' => __( 'Bart&#305;n' ),
		'TR75' => __( 'Ardahan' ),
		'TR76' => __( 'I&#287;d&#305;r' ),
		'TR77' => __( 'Yalova' ),
		'TR78' => __( 'Karab&#252;k' ),
		'TR79' => __( 'Kilis' ),
		'TR80' => __( 'Osmaniye' ),
		'TR81' => __( 'D&#252;zce' ),
	),
	'TZ' => array( // Tanzania States.
		'TZ01' => __( 'Arusha' ),
		'TZ02' => __( 'Dar es Salaam' ),
		'TZ03' => __( 'Dodoma' ),
		'TZ04' => __( 'Iringa' ),
		'TZ05' => __( 'Kagera' ),
		'TZ06' => __( 'Pemba North' ),
		'TZ07' => __( 'Zanzibar North' ),
		'TZ08' => __( 'Kigoma' ),
		'TZ09' => __( 'Kilimanjaro' ),
		'TZ10' => __( 'Pemba South' ),
		'TZ11' => __( 'Zanzibar South' ),
		'TZ12' => __( 'Lindi' ),
		'TZ13' => __( 'Mara' ),
		'TZ14' => __( 'Mbeya' ),
		'TZ15' => __( 'Zanzibar West' ),
		'TZ16' => __( 'Morogoro' ),
		'TZ17' => __( 'Mtwara' ),
		'TZ18' => __( 'Mwanza' ),
		'TZ19' => __( 'Coast' ),
		'TZ20' => __( 'Rukwa' ),
		'TZ21' => __( 'Ruvuma' ),
		'TZ22' => __( 'Shinyanga' ),
		'TZ23' => __( 'Singida' ),
		'TZ24' => __( 'Tabora' ),
		'TZ25' => __( 'Tanga' ),
		'TZ26' => __( 'Manyara' ),
		'TZ27' => __( 'Geita' ),
		'TZ28' => __( 'Katavi' ),
		'TZ29' => __( 'Njombe' ),
		'TZ30' => __( 'Simiyu' ),
	),
	'LK' => array(),
	'SE' => array(),
	'US' => array( // United States.
		'AL' => __( 'Alabama' ),
		'AK' => __( 'Alaska' ),
		'AZ' => __( 'Arizona' ),
		'AR' => __( 'Arkansas' ),
		'CA' => __( 'California' ),
		'CO' => __( 'Colorado' ),
		'CT' => __( 'Connecticut' ),
		'DE' => __( 'Delaware' ),
		'DC' => __( 'District Of Columbia' ),
		'FL' => __( 'Florida' ),
		'GA' => _x( 'Georgia', 'US state of Georgia' ),
		'HI' => __( 'Hawaii' ),
		'ID' => __( 'Idaho' ),
		'IL' => __( 'Illinois' ),
		'IN' => __( 'Indiana' ),
		'IA' => __( 'Iowa' ),
		'KS' => __( 'Kansas' ),
		'KY' => __( 'Kentucky' ),
		'LA' => __( 'Louisiana' ),
		'ME' => __( 'Maine' ),
		'MD' => __( 'Maryland' ),
		'MA' => __( 'Massachusetts' ),
		'MI' => __( 'Michigan' ),
		'MN' => __( 'Minnesota' ),
		'MS' => __( 'Mississippi' ),
		'MO' => __( 'Missouri' ),
		'MT' => __( 'Montana' ),
		'NE' => __( 'Nebraska' ),
		'NV' => __( 'Nevada' ),
		'NH' => __( 'New Hampshire' ),
		'NJ' => __( 'New Jersey' ),
		'NM' => __( 'New Mexico' ),
		'NY' => __( 'New York' ),
		'NC' => __( 'North Carolina' ),
		'ND' => __( 'North Dakota' ),
		'OH' => __( 'Ohio' ),
		'OK' => __( 'Oklahoma' ),
		'OR' => __( 'Oregon' ),
		'PA' => __( 'Pennsylvania' ),
		'RI' => __( 'Rhode Island' ),
		'SC' => __( 'South Carolina' ),
		'SD' => __( 'South Dakota' ),
		'TN' => __( 'Tennessee' ),
		'TX' => __( 'Texas' ),
		'UT' => __( 'Utah' ),
		'VT' => __( 'Vermont' ),
		'VA' => __( 'Virginia' ),
		'WA' => __( 'Washington' ),
		'WV' => __( 'West Virginia' ),
		'WI' => __( 'Wisconsin' ),
		'WY' => __( 'Wyoming' ),
		'AA' => __( 'Armed Forces (AA)' ),
		'AE' => __( 'Armed Forces (AE)' ),
		'AP' => __( 'Armed Forces (AP)' ),
	),
	'VN' => array(),
	'YT' => array(),
	'ZA' => array( // South African states.
		'EC'  => __( 'Eastern Cape' ),
		'FS'  => __( 'Free State' ),
		'GP'  => __( 'Gauteng' ),
		'KZN' => __( 'KwaZulu-Natal' ),
		'LP'  => __( 'Limpopo' ),
		'MP'  => __( 'Mpumalanga' ),
		'NC'  => __( 'Northern Cape' ),
		'NW'  => __( 'North West' ),
		'WC'  => __( 'Western Cape' ),
	),
);
