<?php
// create custom plugin settings menu
add_action('admin_menu', 'sr_plugin_create_menu');

function sr_plugin_create_menu() {

	//create new top-level menu
	add_menu_page('Enrolled Students', 'Enrolled Students', 'manage_options','enrolled-students', 'sr_plugin_settings_page' ,  'dashicons-admin-users' );

	//call register settings function
	add_action( 'admin_init', 'register_my_cool_plugin_settings' );
}


function register_my_cool_plugin_settings() {
	//register our settings
	register_setting( 'sl-plugin-settings-group', 'sr_instagram' );
	register_setting( 'sl-plugin-settings-group', 'sr_twitter' );
	register_setting( 'sl-plugin-settings-group', 'sr_facebook' );
}

function sr_plugin_settings_page() {
?>
<div class="wrap" style="background: #fff; padding: 10px 25px;">
<h1>Enrolled Students</h1>
<hr>
	
<table id="stdtable" width="100%" class="cell-border compact stripe hover">
  <thead>
    <tr role="row">
	  <th>Student ID</th>
	  <th>Student Name</th>
	  <th>Course</th>
	  <th>Date Completed</th>
	  <th>Course Grade</th>
	  <th>Report Grade</th>
    </tr>
  </thead>
  <tbody>

<?php 

$users = get_users( array( 'fields' => array( 'ID' ), 'role' => 'customer' ) );
foreach($users as $user){
    
    
    $userinfo = get_user_meta($user->ID);
  /*  echo "<pre>";
    print_r($userinfo);
    echo "</pre>";*/
    $couse_info = unserialize($userinfo['_sfwd-course_progress'][0]);
    /*echo "<pre>";
    	print_r($couse_info);
    echo "</pre>";*/
    foreach ($couse_info as $key => $value) {
    
	$user_info = get_userdata($user->ID);
	$uci = get_field( "dcjscourseid", $key );
	echo "<tr>";
	//echo '<td style="display:none;">'.$user->ID.'</td>';
	echo '<td>'.$user_info->user_login.'</td>';
	echo '<td><a href='.admin_url( 'user-edit.php?user_id=' . $user->ID, 'http' ).'> '.$userinfo['first_name'][0].' '.$userinfo['last_name'][0].'</a></td>';
	echo '<td><a href="'.get_site_url().'/wp-admin/post.php?post='.$key.'&action=edit"> '.get_the_title($key).'</a></td>';
	if(!empty($userinfo['course_completed_'.$key][0])){
		echo "<td>".date("Y-m-d",$userinfo['course_completed_'.$key][0])."</td>";	
	}else {
		echo '<td> Not Completed </td>';
	}
	
	$quiz = unserialize($userinfo['_sfwd-quizzes'][0]);

	$abc = end($quiz);
/*	echo "<pre>";
		print_r($abc);
	echo "</pre>";*/
	if($abc['course'] == $key){
	echo '<td>'.$abc['percentage'].'%</td>';
	} else{
	echo '<td>No Exam</td>';
	}

	echo "<td><a href='#' class='sendinfo button button-default' course-id='".$uci."' std-user-name='".$user_info->user_login."' std-fl-name='".$userinfo['first_name'][0].' '.$userinfo['last_name'][0]."' > Send </a></td>";
	echo "</tr>";
    }// foreach
    
    
}//foreach

?>

   
  </tbody>
</table>




</div>


<?php



 } ?>