<?php
/*
Plugin Name: Student Reports
Plugin URI: https://www.fiverr.com/zaheerabbasagha
Description: PLugin display and send student reports.
Version: 1.0
Author: Zaheer Abbas Aghani
Author URI: https://profiles.wordpress.org/zaheer01/
License: GPLv3 or later
Text Domain: studentreports
Domain Path: /languages
*/

defined("ABSPATH") or die("No direct access!");
class StudentReports {

function __construct() {
	add_action('init', array($this, 'bpem_start_from_here'));
	add_action('wp_enqueue_scripts', array($this, 'bpem_enqueue_script_front'));
	//add_action('init', array($this, 'rudr_instagram_api_curl_connect'));
	add_action('admin_enqueue_scripts', array($this, 'sr_enqueue_script_dashboard'));
	
}



function bpem_start_from_here() {
	require_once plugin_dir_path(__FILE__) . 'sr-dash/dashboard-widget.php';
	require_once plugin_dir_path(__FILE__) . 'sr-dash/dashboard-student-enroll.php';
	require_once plugin_dir_path(__FILE__) . 'sr-dash/dashboard-student-enroll-process.php';
	require_once plugin_dir_path(__FILE__) . 'sr-dash/send_student_info_external_server.php';
}

// Enqueue Style and Scripts

function bpem_enqueue_script_front() {
//Style & Script
wp_enqueue_style('sr-style', plugins_url('sr-public/assets/css/sl_style.css',__FILE__),'1.0.0','all');
wp_enqueue_script('sr-script', plugins_url('sr-public/assets/js/sl_script.js',__FILE__),array('jquery'),'1.0.0',true);

}


// Enqueue Style and Scripts

function sr_enqueue_script_dashboard() {
//Style & Script
wp_enqueue_style('sr-dash-style', plugins_url('sr-public/assets/css/sr_dashboard_style.css',__FILE__),'1.0.0','all');

wp_enqueue_style( 'jquery-ui-datepicker-style' , 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/themes/smoothness/jquery-ui.css');
wp_enqueue_style('datatables', 'https://cdn.datatables.net/v/dt/dt-1.10.20/datatables.min.css' );

  wp_enqueue_script( 'jquery-ui-datepicker' );


 wp_enqueue_script('datatables', 'https://cdn.datatables.net/v/dt/dt-1.10.20/datatables.min.js', array('jquery') );

 wp_enqueue_script('dataTables.buttons', 'https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js', array('jquery') );

 wp_enqueue_script('jszip', 'https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js', array('jquery') );

 wp_enqueue_script('buttons.html5', 'https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js', array('jquery') );
/*wp_enqueue_script('date_range','http://cdn.datatables.net/plug-ins/1.10.20/filtering/row-based/range_dates.js',array('jquery'),'1.10.20',true);*/

  //wp_localize_script( 'datatables', 'datatablesajax', array('url' => admin_url('admin-ajax.php')) );


wp_enqueue_script('sr-d-script', plugins_url('sr-public/assets/js/sr_dashboard_script.js',__FILE__),array('jquery'),'1.0.0',true);

wp_localize_script( 'sr-d-script', 'ajax_object',
            array( 'ajax_url' => admin_url( 'admin-ajax.php' ), 'imagepath' => plugins_url( '/sr-public/assets/images', __FILE__ ) ) );





//wp_enqueue_script('sr-script', plugins_url('sr-public/assets/js/sl_script.js',__FILE__),array('jquery'),'1.0.0',true);
}







} // class ends

// CHECK WETHER CLASS EXISTS OR NOT.

if (class_exists('StudentReports')) {
$obj = new StudentReports();
}